% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ernm.R
\name{ernm}
\alias{ernm}
\title{fits an ERNM model}
\usage{
ernm(
  formula,
  tapered = TRUE,
  tapering_r = 3,
  modelArgs = list(),
  nodeSamplingPercentage = 0.2,
  modelType = NULL,
  likelihoodArgs = list(),
  fullToggles = c("Compound_NodeTieDyad_Neighborhood", "DefaultVertex"),
  missingToggles = c("Compound_NodeTieDyadMissing_NeighborhoodMissing", "VertexMissing"),
  ...
)
}
\arguments{
\item{formula}{model formula}

\item{tapered}{should the model be tapered}

\item{tapering_r}{the tapering parameter (tau = 1/(tapering_r^2 +5))}

\item{modelArgs}{additiional arguments for the model, e.g. tapering parameters that override the defaults}

\item{nodeSamplingPercentage}{how often are nodal variates toggled}

\item{modelType}{either FullErnmModel or MissingErnmModel if NULL will check for missingness}

\item{likelihoodArgs}{additiional arguments for the ernmLikelihood}

\item{fullToggles}{a character vector of length 2 indicating the dyad and vertex toggle types for the unconditional simulations}

\item{missingToggles}{a character vector of length 2 indicating the dyad and vertex toggle types for the conditional simulations}

\item{...}{additional parameters for ernmFit}
}
\value{
a fitted model
}
\description{
fits an ERNM model
}
