% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{rbernoulli}
\alias{rbernoulli}
\title{Random Bernoulli graph}
\usage{
rbernoulli(n, p = 0.5)
}
\arguments{
\item{n}{Integer vector. Size of the graph. If \code{length(n) > 1}, then it will
a list of random graphs.}

\item{p}{Probability of a tie. This may be either a scalar, or a vector of the
same length of \code{n}.}
}
\value{
If \code{n} is a single number, a square matrix of size \code{n} with zeros in
the diagonal. Otherwise it returns a list of \code{length(n)} square matrices of
sizes equal to those specified in \code{n}.
}
\description{
Random Bernoulli graph
}
\examples{
# A graph of size 4
rbernoulli(4)

# 3 graphs of various sizes
rbernoulli(c(3, 4, 2))

# 3 graphs of various sizes and different probabilities
rbernoulli(c(3, 4, 6), c(.1, .2, .3))
}
