% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R, R/ergm-terms-index.R
\name{ergmAuxiliary}
\alias{ergmAuxiliary}
\alias{search.ergmAuxiliaries}
\title{Auxiliaries to Facilitate Terms in Exponential Family Random Graph Models}
\usage{
search.ergmAuxiliaries(search, keywords, name, packages)
}
\arguments{
\item{search}{optional character search term to search for in the text of the
term descriptions. Only matching terms will be returned. Matching is case
insensitive.}

\item{keywords}{optional character vector of keyword tags to use to
restrict the results (i.e. 'curved', 'triad-related')}

\item{name}{optional character name of a specific term to return}

\item{packages}{optional character vector indicating the subset of packages in which to search}
}
\description{
This page is intended for term developers and provides information about auxiliaries---terms that do not produce statistics of their own but provide useful data structures for other terms to use. It also provides an indexed list of the possible auxiliaries currently visible to the \CRANpkg{ergm} API. Terms can also be searched via \code{\link{search.ergmAuxiliaries}}, and help for an individual auxiliaries can be obtained with \verb{ergmAuxiliary?<term>} or \code{help("<term>-ergmAuxiliary")}.

By convention, their names are prefixed with a dot.
}
\section{Auxiliary index}{


\ergmCSS

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmAuxiliary"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmAuxiliary"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmAuxiliary"))}}
\subsection{All terms}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmAuxiliary"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmAuxiliary"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmAuxiliary"))}}
}

\subsection{Terms by keywords}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocLatex(ergm:::.termToc("ergmAuxiliary"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocText(ergm:::.termToc("ergmAuxiliary"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocHtml(ergm:::.termToc("ergmAuxiliary"))}}
}
}

\examples{
\donttest{
# find all of the auxiliaries
search.ergmAuxiliaries()
}
}
\seealso{
\code{\link[=ergm-package]{ergm}} package, \code{\link{ergm}}, \code{\link[network:network]{network}}, \code{\link[network:network.extraction]{\%v\%}}, \code{\link[network:network.extraction]{\%n\%}}
}
\keyword{internal}
\keyword{models}
