% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.gof.R
\name{control.gof}
\alias{control.gof}
\alias{control.gof.formula}
\alias{control.gof.ergm}
\title{Auxiliary for Controlling ERGM Goodness-of-Fit Evaluation}
\usage{
control.gof.formula(
  nsim = 100,
  MCMC.burnin = 10000,
  MCMC.interval = 1000,
  MCMC.batch = 0,
  MCMC.prop = trim_env(~sparse + .triadic),
  MCMC.prop.weights = "default",
  MCMC.prop.args = list(),
  MCMC.maxedges = Inf,
  MCMC.packagenames = c(),
  MCMC.runtime.traceplot = FALSE,
  network.output = "network",
  seed = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE
)

control.gof.ergm(
  nsim = 100,
  MCMC.burnin = NULL,
  MCMC.interval = NULL,
  MCMC.batch = NULL,
  MCMC.prop = NULL,
  MCMC.prop.weights = NULL,
  MCMC.prop.args = NULL,
  MCMC.maxedges = NULL,
  MCMC.packagenames = NULL,
  MCMC.runtime.traceplot = FALSE,
  network.output = "network",
  seed = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE
)
}
\arguments{
\item{nsim}{Number of networks to be randomly drawn using Markov chain Monte
Carlo.  This sample of networks provides the basis for comparing the model
to the observed network.}

\item{MCMC.burnin}{Number of proposals before any MCMC sampling is done. It
typically is set to a fairly large number.}

\item{MCMC.interval}{Number of proposals between sampled statistics.}

\item{MCMC.batch}{if not 0 or \code{NULL}, sample about this many
networks per call to the lower-level code; this can be useful if
\verb{output=} is a function, where it can be used to limit the number
of networks held in memory at any given time.}

\item{MCMC.prop}{Specifies the proposal (directly) and/or
a series of "hints" about the structure of the model being
sampled. The specification is in the form of a one-sided formula
with hints separated by \code{+} operations. If the LHS exists and is
a string, the proposal to be used is selected directly.

A common and default "hint" is \code{~sparse}, indicating
that the network is sparse and that the sample should put roughly
equal weight on selecting a dyad with or without a tie as a
candidate for toggling.}

\item{MCMC.prop.weights}{Specifies the proposal
distribution used in the MCMC Metropolis-Hastings algorithm.  Possible
choices depending on selected \code{reference} and \code{constraints}
arguments of the \code{\link[=ergm]{ergm()}} function, but often include \code{"TNT"}
and \code{"random"}, and the \code{"default"} is to use the one with the
highest priority available.}

\item{MCMC.prop.args}{An alternative, direct way of
specifying additional arguments to proposal.}

\item{MCMC.maxedges}{The maximum number of edges that may occur during the MCMC sampling. If this number is exceeded at any time, sampling is stopped immediately.}

\item{MCMC.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{MCMC.runtime.traceplot}{Logical: If \code{TRUE}, plot traceplots of the MCMC
sample.}

\item{network.output}{R class with which to output networks. The options are
"network" (default) and "edgelist.compressed" (which saves space but only
supports networks without vertex attributes)}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[=set.seed]{set.seed()}}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See \code{\link{ergm-parallel}}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Defaults
to using the \pkg{parallel} package with PSOCK clusters. See
\code{\link{ergm-parallel}}.}

\item{parallel.version.check}{Logical: If TRUE, check that the
version of \CRANpkg{ergm} running on the slave
nodes is the same as that running on the master node.}

\item{parallel.inherit.MT}{Logical: If TRUE, slave nodes and
processes inherit the \code{\link[=set.MT_terms]{set.MT_terms()}} setting.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning ERGM Goodness-of-Fit
Evaluation.

The \code{control.gof.ergm} version is intended to be used
with \code{\link[=gof.ergm]{gof.ergm()}} specifically and will "inherit" as many control
parameters from \code{\link{ergm}} fit as possible().
}
\details{
This function is only used within a call to the \code{\link[=gof]{gof()}} function.
See the Usage section in \code{\link[=gof]{gof()}} for details.
}
\seealso{
\code{\link[=gof]{gof()}}. The \code{\link[=control.simulate]{control.simulate()}} function
performs a similar function for \code{\link[=simulate.ergm]{simulate.ergm()}};
\code{\link[=control.ergm]{control.ergm()}} performs a similar function for
\code{\link[=ergm]{ergm()}}.
}
