% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{Sum-operator-ergmTerm}
\alias{Sum-operator-ergmTerm}
\alias{InitErgmTerm.Sum}
\alias{Sum-ergmTerm}
\alias{InitWtErgmTerm.Sum}
\title{A sum (or an arbitrary linear combination) of one or more formulas}
\usage{
# binary: Sum(formulas, label)

# valued: Sum(formulas, label)
}
\arguments{
\item{formulas}{a list (constructed using \code{\link[=list]{list()}} or \code{\link[=c]{c()}}) of \code{\link[=ergm]{ergm()}}-style formulas whose RHS gives the statistics to be evaluated, or a single formula.

If a formula in the list has an LHS, it is interpreted as follows:
\itemize{
\item a numeric scalar: Network statistics of this formula will be multiplied by this.
\item a numeric vector: Corresponding network statistics of this formula will be multiplied by this.
\item a numeric matrix: Vector of network statistics will be pre-multiplied by this.
\item a character string: One of several predefined linear combinations. Currently supported presets are as follows:
\itemize{
\item \code{"sum"} Network statistics of this formula will be summed up; equivalent to \code{matrix(1,1,p)} , where \code{p} is the length of the network statistic vector.
\item \code{"mean"} Network statistics of this formula will be averaged; equivalent to \code{matrix(1/p,1,p)} , where \code{p} is the length of the network statistic vector.
}
}}

\item{label}{used to specify the names of the elements of the resulting term sum vector. If \code{label} is a character vector of length 1,
it will be recycled with indices appended. If a function is specified, \code{formulas} parameter names are extracted and their list of character vectors is passed \code{label}.}
}
\description{
This operator sums up the RHS statistics of the input formulas elementwise.
}
\details{
Note that each formula must either produce the same number of
statistics or be mapped through a matrix to produce the same
number of statistics.

A single formula is also permitted. This can be useful if one
wishes to, say, scale or sum up the statistics returned by a formula.

Offsets are ignored unless there is only one formula and the transformation only scales the statistics (i.e., the effective transformation matrix is diagonal).

Curved models are supported, subject to some limitations. In particular, the first model's etamap will be used, overwriting the others. If \code{label} is not of length 1, it should have an \code{attr} -style attribute \code{"curved"} specifying the names for the curved parameters.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{operator}
