% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.hotelling.diff.test.R
\name{geweke.diag.mv}
\alias{geweke.diag.mv}
\title{Multivariate version of \code{coda}'s \code{\link[coda:geweke.diag]{coda::geweke.diag()}}.}
\usage{
geweke.diag.mv(x, frac1 = 0.1, frac2 = 0.5, split.mcmc.list = FALSE, ...)
}
\arguments{
\item{x}{an \code{\link{mcmc}}, \code{\link{mcmc.list}}, or just a matrix with
observations in rows and variables in columns.}

\item{frac1, frac2}{the fraction at the start and, respectively, at
the end of the sample to compare.}

\item{split.mcmc.list}{when given an \code{mcmc.list}, whether to test
each chain individually.}

\item{...}{additional arguments, passed on to
\code{\link[=approx.hotelling.diff.test]{approx.hotelling.diff.test()}}, which passes them to
\code{\link[=spectrum0.mvar]{spectrum0.mvar()}}, etc.; in particular, \verb{order.max=} can be used
to limit the order of the AR model used to estimate the effective
sample size.}
}
\value{
An object of class \code{htest}, inheriting from that returned
by \code{\link[=approx.hotelling.diff.test]{approx.hotelling.diff.test()}}, but with p-value considered to
be 0 on insufficient sample size.
}
\description{
Rather than comparing each mean independently, compares them
jointly. Note that it returns an \code{htest} object, not a \code{geweke.diag}
object.
}
\note{
If \code{\link[=approx.hotelling.diff.test]{approx.hotelling.diff.test()}} returns an error, then
assume that burn-in is insufficient.
}
\seealso{
\code{\link[coda:geweke.diag]{coda::geweke.diag()}}, \code{\link[=approx.hotelling.diff.test]{approx.hotelling.diff.test()}}
}
