% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_proposal.R
\name{ergm_proposal}
\alias{ergm_proposal}
\alias{ergm_proposal.NULL}
\alias{ergm_proposal.ergm_proposal}
\alias{ergm_proposal.character}
\alias{ergm_proposal.formula}
\alias{ergm_proposal.ergm}
\title{Functions to initialize the ergm_proposal object}
\usage{
ergm_proposal(object, ...)

\method{ergm_proposal}{character}(
  object,
  arguments,
  nw,
  ...,
  response = NULL,
  reference = ~Bernoulli
)

\method{ergm_proposal}{formula}(
  object,
  arguments,
  nw,
  weights = "default",
  class = "c",
  reference = ~Bernoulli,
  response = NULL,
  ...
)

\method{ergm_proposal}{ergm}(
  object,
  ...,
  constraints = NULL,
  arguments = NULL,
  nw = NULL,
  weights = NULL,
  class = "c",
  reference = NULL,
  response = NULL
)
}
\arguments{
\item{object}{Either a character, a \code{\link{formula}} or an
\code{\link{ergm}} object.  The \code{\link{formula}} should be of the format documented in the \code{constraints} argument of \code{\link[=ergm]{ergm()}} and in the \link[=ergm-constraints]{ERGM constraints} documentation.}

\item{\dots}{Further arguments passed to other functions.}

\item{arguments}{A list of parameters used by the InitErgmProposal routines}

\item{nw}{The network object originally given to \code{\link{ergm}}
via 'formula'}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{reference}{A one-sided formula specifying
the reference measure (\eqn{h(y)}) to be used.
See help for \link[=ergm-references]{ERGM reference measures} implemented in the
\strong{\link[=ergm-package]{ergm}} package.}

\item{weights}{Specifies the method used to allocate probabilities of being
proposed to dyads; options are "TNT", "TNT10", "random", "nonobserved" and
"default"; default="default"}

\item{class}{The class of the proposal; choices include "c", "f", and "d"
default="c".}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being simulated. See the
documentation for a similar argument for \code{\link{ergm}} and see
\link[=ergm-constraints]{list of implemented constraints} for more information.}
}
\value{
Returns an ergm_proposal object: a list with class \code{ergm_proposal}
containing the following named elements:
\item{name}{the C name of the proposal}
\item{inputs}{inputs to be passed to C}
\item{pkgname}{shared library name where the proposal
can be found (usually \code{"ergm"})}
\item{reference}{the reference distribution}
\item{arguments}{list of arguments passed to
the \code{InitErgmProposal} function; in particular,
\describe{
\item{\code{constraints}}{list of constraints}
}
}
}
\description{
S3 Functions that initialize the Metropolis-Hastings Proposal (ergm_proposal)
object using the \verb{InitErgmProposal.*} function that corresponds to the name given in
'object'.  These functions are not generally called directly by the user.
See \link{ergm-proposals} for general explanation and lists of available
Metropolis-Hastings proposal types.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: \code{object} argument is a character string
giving the \R name of the proposal.

\item \code{formula}: \code{object} argument is an ERGM constraint formula.

\item \code{ergm}: \code{object} argument is an \code{\link{ergm}} fit whose proposals are extracted which is reproduced as best as possible.
}}

\seealso{
\code{\link{InitErgmProposal}}
}
\keyword{internal}
\keyword{models}
