% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmProposal.blockdiag.R
\name{ergm_block_diag_samp_info}
\alias{ergm_block_diag_samp_info}
\title{Compute and serialize information needed by the block-diagonal
Metropolis-Hastings samplers.}
\usage{
ergm_block_diag_samp_info(nw, a)
}
\arguments{
\item{nw}{the network of interest.}

\item{a}{either a vector (of any mode) whose \eqn{i}th element
identifies the block to which vertex \eqn{i} belongs. Blocks must
be continguous.}
}
\value{
An object of nonce class \code{ergm_block_diag_samp_info} with
the following elements at this time:
\describe{

\item{\code{nblk}}{number of blocks}

\item{\code{pos} (for unipartite), \code{b1pos} and \code{b2pos} (for
bipartite)}{vectors of length \code{nblk+1} such that
\code{(pos[i]+1):(pos[i+1])} are the numbers of the vertices in block
\code{i}.}

\item{\code{cumwt}}{vector of length \code{nblk} with values such that
generating \eqn{U\sim \mathrm{Uniform}(0,1)}{U ~ Uniform(0,1)}
selecting the index of the first element in \code{cumwt} that is greater
than \eqn{U} will sample from the blocks in proportion to the
number of dyads in the block.}

}

In addition, an attribute \code{"ndyads"} is attached, containing the
total number of dyads in all blocks put together.
}
\description{
Given a nodal attribute vector specifying the blocks
returns a list containing information needed to efficiently
sample dyads in those blocks.
}
\keyword{internal}
