% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_methods.R
\name{idList}
\alias{idList}
\alias{idList,MetaboSet-method}
\title{Identification list}
\usage{
idList(object, id.database = mslib)

\S4method{idList}{MetaboSet}(object, id.database = mslib)
}
\arguments{
\item{object}{A 'MetaboSet' S4 object containing the experiment data. The experiment has to be previously deconvolved, aligned and identified.}

\item{id.database}{The mass-spectra library to be compared with the empirical spectra. By default, the MassBank - Mass Bank of North America (MoNa) database are employed (mslib object).}
}
\value{
\code{idList} returns an S3 object:
     \item{AlignID}{The unique Tag for found metabolite by eRah. Each metabolite found by eRah for a given experiment has an unique AlignID tag number.}
     \item{tmean}{The mean compound retention time.}
     \item{Name.X}{the name of the Xst/nd/rd... hit. idList return as many X (hits) as n.putative selected with \code{\link{identifyComp}}.}
     \item{FoundIn}{The number of samples in which the compound has been detected (the number of samples where the compound area is non-zero).}
     \item{MatchFactor.X}{The match factor/score of spectral similarity (spectral correlation).}
     \item{DB.Id.X}{The identification number of the library. Each metbolite in the reference library has a different DB.Id number.}
     \item{CAS.X}{the CAS number of each identified metabolite.}
}
\description{
The list of identified metabolites in a given experiment
}
\details{
Returns an identification table containing the names, match scores, and other variables for a given experiment.
}
\seealso{
\code{\link{alignList}} \code{\link{dataList}}
}
