% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQ_functions.R
\name{eq5d}
\alias{eq5d}
\title{eq5d}
\usage{
eq5d(
  x,
  country = NULL,
  version = "5L",
  dim.names = c("mo", "sc", "ua", "pd", "ad")
)
}
\arguments{
\item{x}{A vector of 5-digit EQ-5D-3L state indexes or a matrix/data.frame with columns corresponding to EQ-5D state dimensions}

\item{country}{String vector indicating country names or  ISO3166 Alpha 2 / 3 country codes.}

\item{version}{String indicating which version to use. Options are '5L'  (default), '3L', 'xw', 'xwr', and 'Y3L'.}

\item{dim.names}{A vector of dimension names to identify dimension columns.}
}
\value{
A vector of values or data.frame with one column for each value set requested.
}
\description{
Get EQ-5D index values for the -3L, -5L, crosswalk (-3L value set applied to -5L health states),  reverse crosswealk (-5L value set applied to -3L health states), and -Y-3L
}
\examples{
# US -3L value set
eq5d(c(11111, 12321, 32123, 33333), 'US', '3L') 
# Danish and US -5L value sets applied to -3L descriptives, i.e. reverse crosswalk
eq5d(make_all_EQ_states('3L'), c('DK', 'US'), 'XWR') 
# US -5L value set
eq5d(c(11111, 12321, 32153, 55555), 'US', '5L') 
}
