% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf.R
\name{summary_database}
\alias{summary_database}
\title{Summary CMIP6 model output file status}
\usage{
summary_database(
  dir,
  by = c("activity", "experiment", "variant", "frequency", "variable", "source",
    "resolution"),
  mult = c("skip", "latest"),
  append = FALSE,
  recursive = FALSE,
  update = FALSE,
  warning = TRUE
)
}
\arguments{
\item{dir}{A single string indcating the directory where CMIP6 model output
NetCDF files are stored.}

\item{by}{The grouping column to summary the database status. Should be a
subeset of:
\itemize{
\item \code{"experiment"}: root experiment identifiers
\item \code{"source"}: model identifiers
\item \code{"variable"}: variable identifiers
\item \code{"activity"}: activity identifiers
\item \code{"frequency"}: sampling frequency
\item \code{"variant"}: variant label
\item \code{"resolution"}: approximate horizontal resolution
}}

\item{mult}{Actions when multiple files match a same case in the CMIP6
index. If \code{"latest"}, the file with latest modification time
will be used. If \code{"skip"}, all matched files will be skip and this
case will be kept as unmatched. Default: \code{"skip"}.}

\item{append}{If \code{TRUE}, status of CMIP6 files will only be updated if they
are not found in previous summary. This is useful if CMIP6 files are
stored in different directories. Default: \code{FALSE}.}

\item{recursive}{If \code{TRUE}, scan recursively into directories. Default:
\code{FALSE}.}

\item{update}{If \code{TRUE}, the output file index will be updated based
on the matched NetCDF files in specified directory. If \code{FALSE}, only
current loaded index will be updated, but the actual index
database file saved in \code{\link[=get_data_dir]{get_data_dir()}} will remain unchanged.
Default: \code{FALSE}.}

\item{warning}{If \code{TRUE}, warning messages will show when multiple files
match a same case. Default: \code{TRUE}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing corresponding grouping
columns plus:\tabular{lll}{
   Column \tab Type \tab Description \cr
   \code{datetime_start} \tab POSIXct \tab Start date and time of simulation \cr
   \code{datetime_end} \tab POSIXct \tab End date and time of simulation \cr
   \code{file_num} \tab Integer \tab Total number of file per group \cr
   \code{file_size} \tab Units (Mbytes) \tab Approximate total size of file \cr
   \code{dl_num} \tab Integer \tab Total number of file downloaded \cr
   \code{dl_percent} \tab Units (\%) \tab Total percentage of file downloaded \cr
   \code{dl_size} \tab Units (Mbytes) \tab Total size of file downloaded \cr
}


Also an attribute \code{not_matched} is added to the returned
\code{\link[data.table:data.table]{data.table::data.table()}} which contains meta data for those CMIP6 output
files that are not covered by current CMIP6 output file index.

For the meaning of grouping columns, see \code{\link[=init_cmip6_index]{init_cmip6_index()}}.
}
\description{
\code{summary_database()} scan the directory specified and returns a
\code{\link[=data.table]{data.table()}} containing summary information about all the CMIP6
files available against the output file index loaded using
\code{\link[=load_cmip6_index]{load_cmip6_index()}}.
}
\details{
\code{summary_database()} uses \link[future.apply:future_lapply]{future.apply}
underneath. You can use your preferable future backend to
speed up data extraction in parallel. By default, \code{summary_database()} uses
\code{future::sequential} backend, which runs things in sequential.
}
\examples{
\dontrun{
summary_database()

summary_database(by = "experiment")
}
}
