% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNeuroTable.R
\name{printTop10Drugs}
\alias{printTop10Drugs}
\title{Print Top 10 Drugs}
\usage{
printTop10Drugs(neuroepso, neuroesso, neuroepi, neuroepisem, neurofenics)
}
\arguments{
\item{neuroepso}{Ranked list of drug names co-occurring with EpSO}

\item{neuroesso}{Ranked list of drug names co-occurring with ESSO}

\item{neuroepi}{Ranked list of drug names co-occurring with EPILONT}

\item{neuroepisem}{Ranked list of drug names co-occurring with EPISEM}

\item{neurofenics}{Ranked list of drug names co-occurring with FENICS}
}
\value{
data frame with top 10 drugs for each ontology
}
\description{
Print Top 10 Drugs
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
utils::data(rawDrugNamesCoOcFENICS, package="epos")
atchashda <-
readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashaa <-
  readAtcMapIntoHashMapAtcCodesAtcNames(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashsec <-
  readSecondLevelATC(
    system.file("extdata", "atc-secondlevel.map", package = "epos"), "\t")
epso <- rawDrugNamesCoOcEpSO
neuroepso <- filterNeuroDrugs(epso, atchashda)
esso <- rawDrugNamesCoOcESSO
neuroesso   <- filterNeuroDrugs(esso, atchashda)
epi <- rawDrugNamesCoOcEPILONT
neuroepi    <- filterNeuroDrugs(epi, atchashda)
episem <- rawDrugNamesCoOcEPISEM
neuroepisem <- filterNeuroDrugs(episem, atchashda)
fenics <- rawDrugNamesCoOcFENICS
neurofenics <- filterNeuroDrugs(fenics, atchashda)
top10table <- printTop10Drugs(neuroepso, neuroesso, neuroepi, neuroepisem, neurofenics)
\dontrun{
  print(xtable::xtable(top10table, type = "latex"), 
    file = "top10table.tex")
}
}
