% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordsFromEpmGrid.R
\name{coordsFromEpmGrid}
\alias{coordsFromEpmGrid}
\title{Retrieve coordinates from epmGrid}
\usage{
coordsFromEpmGrid(x, sites)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{sites}{locations of sites, see details.}
}
\value{
matrix with x and y coordinates.
}
\description{
Return the centroid coordinates for a specified set of grid cells.
}
\details{
Sites can be cell indices as a numeric vector, or you can specify 
	\code{sites = 'all'} to get all grid cells. If the epmGrid object
	is hexagon-based, then all grid cells that are occupied are returned.
	If the epmGrid is square-based, then all grid cells, occupied or empty,
	are returned.
}
\examples{
tamiasEPM

# from cell indices
cells <- c(2703, 90, 3112, 179)
coordsFromEpmGrid(tamiasEPM, cells)

# for all grid cells
dim(coordsFromEpmGrid(tamiasEPM, 'all'))


}
\author{
Pascal Title
}
