% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idf.R
\name{read_idf}
\alias{read_idf}
\title{Read an EnergyPlus Input Data File (IDF)}
\usage{
read_idf(path, idd = NULL)
}
\arguments{
\item{path}{A path to an EnergyPlus IDF file or a string that can be parsed as
an IDF. The file extension does not matter. So models stored in \code{TXT}
format are still able to correctly be parsed.}

\item{idd}{Any acceptable input of \code{\link[=use_idd]{use_idd()}}. If \code{NULL}, which is the
default, the version of IDF will be passed to \code{\link[=use_idd]{use_idd()}}. If the input
IDF does not have a version field (possible for ".ddy" files), then it
will be parsed using the latest version of IDD cached, with a warning.}
}
\value{
An \code{Idf} object.
}
\description{
\code{read_idf} takes an EnergyPlus Input Data File (IDF) as input and returns an
\code{Idf} object. For more details on \code{Idf} object, please see \link[=idf]{Idf class}.
}
\seealso{
\link[=idf]{Idf class}
}
