% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_eplus}
\alias{install_eplus}
\alias{download_eplus}
\title{Download and Install EnergyPlus}
\usage{
install_eplus(ver = "latest", force = FALSE, dir = tempdir())

download_eplus(ver = "latest", dir = getwd())
}
\arguments{
\item{ver}{The EnergyPlus version number, e.g., \code{8.7}; the special value
\code{"latest"} means the latest version (fetched from GitHub releases).}

\item{force}{Whether to install EnergyPlus even if it has already been
installed.}

\item{dir}{Where to save EnergyPlus installer file. Default is current
working directory for \code{download_eplus()} and \code{tempdir()} for
\code{install_eplus()}.}
}
\description{
Download specified version of EnergyPlus for your platform from GitHub and
install it.
}
\details{
\code{download_eplus()} downloads specified version of EnergyPlus from
\href{https://github.com/NREL/EnergyPlus}{EnergyPlus Github Repository}.

\code{install_eplus()} will try to install EnergyPlus into the default location,
e.g.  \file{C:/EnergyPlusVX-Y-0} on Windows,
\file{/usr/local/EnergyPlus-X-Y-0} on Linux, and
\file{/Applications/EnergyPlus-X-Y-0} on MacOS.

Note that the installation process requires administrative privileges
during the installation and you have to run R with administrator (or with
sudo if you are on Linux) to make it work if you are not in interactive mode.
}
