% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{dt_to_load}
\alias{dt_to_load}
\title{Format Long Table to Standard Input for \code{Idf$load()} Method}
\usage{
dt_to_load(dt, string_value = TRUE)
}
\arguments{
\item{dt}{A data.table created using \code{Idf$to_table()} and
\code{IdfObject$to_table()}. \code{dt} should at least contain column \code{id}
(indicator used to distinguish object definitions), \code{class} (class
names). If a \code{name} column exists, it will be preserved.}

\item{string_value}{If \code{TRUE}, all value will be coerced into character and
the \code{value} column of returned \link[data.table:data.table]{datat.table}
will be character type. If \code{FALSE}, the original value will be
preserved and the \code{value} column of returned
\link[data.table:data.table]{data.table} will be list type.}
}
\value{
A \link[data.table:data.table]{data.table} with 5 or 6 columns:
\itemize{
\item \code{id}: Integer type. Used to distinguish each object definition.
\item \code{name}: Character type. Only exists when input \code{dt} has a \code{name} column.
\item \code{class}: Character type.
\item \code{index}: Integer type. Field indices.
\item \code{field}: Character type. Field names.
\item \code{value}: Character or list type. The value of each field to be added.
}
}
\description{
\code{dt_to_load()} takes a \link[data.table:data.table]{data.table}, usually
created from \code{\link[=Idf]{Idf$to_table()}} or \code{\link[=IdfObject]{IdfObject$to_table()}}
with \code{wide} being \code{TRUE}, and format it into a
\link[data.table:data.table]{data.table} in acceptable format for \verb{$load()}
method in \link{Idf} class.
}
\examples{
\dontrun{
# read an example distributed with eplusr
path_idf <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr")
idf <- read_idf(path_idf)

# extract all material object data and return it as a wide table
dt <- idf$to_table(class = "Material", wide = TRUE)

dt_to_load(dt)
}

}
