% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epw.R
\name{download_weather}
\alias{download_weather}
\title{Download EnergyPlus Weather File (EPW) and Design Day File (DDY)}
\usage{
download_weather(pattern, filename = NULL, dir = ".", type = c("all",
  "epw", "ddy"), ask = TRUE, max_match = 3)
}
\arguments{
\item{pattern}{A regular expression used to search locations, e.g. \code{"los angeles.*tmy3"}. The search is case-insensitive.}

\item{filename}{File names (without extension) used to save downloaded files.
Internally, \code{\link[=make.unique]{make.unique()}} is called to ensure unique names.}

\item{dir}{Directory to save downloaded files}

\item{type}{File type to download. Should be one of \code{"all"}, \code{"epw"} and
\code{"ddy"}. If \code{"all"}, both weather files and design day files will be
downloaded.}

\item{ask}{If \code{TRUE}, a command line menu will be shown to let you select
which one to download. If \code{FALSE} and the number of returned results is
less than \code{max_match}, files are downloaded automatically without asking.}

\item{max_match}{The max results allowed to download when \code{ask} is \code{FALSE}.}
}
\value{
A character vector containing paths of downloaded files.
}
\description{
\code{download_weather()} makes it easy to download EnergyPlus weather files (EPW)
and design day files (DDY).
}
\examples{
\dontrun{
download_weather("los angeles.*tmy3", "la")
}
}
\author{
Hongyuan Jia
}
