% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-mut.R
\name{core_mut}
\alias{core_mut}
\title{Determine presence of mutation in core binding sequence}
\usage{
core_mut(dat_in, ag_stim, ag_self)
}
\arguments{
\item{dat_in}{dataframe, output of mhcII_hu(). The stimulating peptide, core pattern, start, and end positions will be pulled from this dataframe.}

\item{ag_stim}{string, amino acid sequence of the stimulating antigen}

\item{ag_self}{string, amino acid sequence of the self antigen}
}
\value{
data frame, peptide with flag of whether or not a mutation is in the core binding sequence
}
\description{
The core_mut() function appends a new column to the peptide dataframe, identifying those that have a mutation in the core binding sequence. Since MHCII has an open binding pocket, it presents peptides that may be several amino acids longer than the core sequence pattern required to bind a particular MHC. In some cases, the user may want to filter their results, in order to keep only peptides with a mutation in the core binding sequence (when compared to the equivalent self peptide). In order to achieve this, the stimulating and self antigens are aligned using a multiple sequence alignment tool, from the bioconductor package msa. The sequence positions of the core in the stimulating peptide are determined, and sequences are kept only if there is a sequence difference between stimulating and self peptides at that position.
}
