% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_functions.R
\name{hazard_ratio}
\alias{hazard_ratio}
\title{Builds a function used to calculate hazard ratios.}
\usage{
hazard_ratio(outcome, adjusted = FALSE, relevel_baseline = FALSE,
  digits = 2, ci = TRUE)
}
\arguments{
\item{outcome}{The dependent variable, specifies a \code{Surv} object
as a string. For example, \code{hazard_ratio("Surv(time, status)")}.}

\item{adjusted}{Whether to adjust for the other covariates, specified by
\code{independents} argument to \code{contingency_table}.}

\item{relevel_baseline}{Whether to use the largest level as the baseline.}

\item{digits}{The number of digits to display.}

\item{ci}{Whether to include a confidence interval in parentheses after the estimate.}
}
\value{
A function that is used to calculate hazard ratios.
}
\description{
Builds a function to fit a Cox model to the
outcome survival object and returns the hazard ratios for
each covariate level.
}
\details{
See documentation for \code{contingency_table} and vignette
for usage.
}
