% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple.bias.R
\name{multiple.bias}
\alias{multiple.bias}
\title{Extract adjusted 2-by-2 table from episensr object}
\usage{
multiple.bias(
  x,
  bias_function = c("selection", "misclassification", "confounders", "probsens.sel",
    "probsens.conf", "probsens"),
  ...
)
}
\arguments{
\item{x}{An object of class 'episensr' or 'episensr.probsens'.}

\item{bias_function}{Bias function to be called. Choices between 'selection',
'misclassification', 'confounders', 'probsens', 'probsens.sel', 'probsens.conf'.}

\item{...}{Additional arguments passed on to methods.}
}
\value{
A list with the elements corresponding to the bias function called.
}
\description{
Extract the adjusted 2-by-2 table from an \code{episensr} function, so that it can
be re-used into an other \code{episensr} function when performing multiple (combined)
bias analysis.
Allowed functions are: \code{selection}, \code{misclassification}, \code{confounders},
\code{probsens}, \code{probsens.sel}, and \code{probsens.conf}.
}
\details{
For probabilistic bias analyses, median of cells are passed to the next function as
starting 2-by-2 table.
}
\examples{
dat <- matrix(c(118, 832, 103, 884),
dimnames = list(c("BC+", "BC-"), c("AD+", "AD-")), nrow = 2, byrow = TRUE)

dat \%>\%
misclassification(., type = "exposure", bias_parms = c(.56, .58, .99, .97)) \%>\%
multiple.bias(., bias_function = "selection", bias_parms = c(.73, .61, .82, .76))
}
\seealso{
\code{\link{selection}}, \code{\link{misclassification}},
\code{\link{confounders}}, \code{\link{probsens}}, \code{\link{probsens.sel}},
\code{\link{probsens.conf}}
}
