% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiHSIC.R
\name{epiHSIC1geno}
\alias{epiHSIC1geno}
\title{Calculate epistasis using HSIC with one genotype input}
\usage{
epiHSIC1geno(geno = NULL, pheno, chunk = 1000, zpthres = 1e-05,
  outfile = "NONE", suffix = ".txt", ...)
}
\arguments{
\item{geno}{is the normalized genotype data. It can be a matrix or a dataframe, or a big.matrix object from \pkg{bigmemory}.
The columns contain the information of variables and the rows contain the information of samples.}

\item{pheno}{is a vector containing the normalized phenotype information.}

\item{chunk}{is the number of variants in each chunk.}

\item{zpthres}{is is the significance threshold to select variant pairs for output. Default is 1e-6.}

\item{outfile}{is the basename of out filename.}

\item{suffix}{is the suffix of out filename.}

\item{...}{not used.}
}
\value{
null
}
\description{
Calculate the significance of epistasis according the definition of HSIC, conduct \eqn{Z} test for HSIC values and 
choose variant pairs with the significance below the given threshold for output.
}
\examples{
# simulate some data
set.seed(123)
geno1 <- matrix(sample(0:2, size = 1000, replace = TRUE, prob = c(0.5, 0.3, 0.2)), ncol = 10)
dimnames(geno1) <- list(row = paste0("IND", 1:nrow(geno1)), col = paste0("rs", 1:ncol(geno1)))
p2 <- rnorm(100, mean = 5, sd = 10)

# normalized data
geno1 <- scale(geno1)
p2 <- as.vector(unlist(scale(p2)))

# one genotypes with quantitative phenotype
epiHSIC1geno(geno = geno1,
pheno = p2, 
outfile = "episcan_1geno_quant", 
suffix = ".txt", 
zpthres = 0.9, 
chunk = 10)

# take a look at the result
res <- read.table("episcan_1geno_quant.txt", 
header = TRUE, 
stringsAsFactors = FALSE)
head(res)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}
