% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowField.R
\name{flowField}
\alias{flowField}
\title{Flow field}
\usage{
flowField(deriv, xlim, ylim, parameters = NULL, system = "two.dim",
  points = 21, col = "gray", arrow.type = "equal",
  arrow.head = 0.05, frac = 1, add = TRUE, xlab = if (system ==
  "two.dim") state.names[1] else "t", ylab = if (system == "two.dim")
  state.names[2] else state.names[1], ...)
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the ODE
system to be analysed. Discussion of the required format of these functions
can be found in the package vignette, or in the help file for the
function \code{\link[deSolve]{ode}}.}

\item{xlim}{In the case of a two-dimensional system, this sets the limits of
the first dependent variable in which gradient reflecting line segments
should be plotted. In the case of a one-dimensional system, this sets the
limits of the independent variable in which these line segments should be
plotted. Should be a \code{\link[base]{numeric}} \code{\link[base]{vector}}
of \code{\link[base]{length}} two.}

\item{ylim}{In the case of a two-dimensional system this sets the limits of
the second dependent variable in which gradient reflecting line segments
should be plotted. In the case of a one-dimensional system, this sets the
limits of the dependent variable in which these line segments should be
plotted. Should be a \code{\link[base]{numeric}} \code{\link[base]{vector}}
of \code{\link[base]{length}} two.}

\item{parameters}{Parameters of the ODE system, to be passed to \code{deriv}.
Supplied as a \code{\link[base]{numeric}} \code{\link[base]{vector}}; the
order of the parameters can be found from the \code{deriv} file. Defaults to
\code{NULL}.}

\item{system}{Set to either \code{"one.dim"} or \code{"two.dim"} to indicate
the type of system being analysed. Defaults to \code{"two.dim"}.}

\item{points}{Sets the density of the line segments to be plotted;
\code{points} segments will be plotted in the x and y directions. Fine tuning
here, by shifting \code{points} up and down, allows for the creation of more
aesthetically pleasing plots. Defaults to \code{11}.}

\item{col}{Sets the colour of the plotted line segments. Should be a
\code{\link[base]{character}} \code{\link[base]{vector}} of
\code{\link[base]{length}} one. Will be reset accordingly if it is of the
wrong \code{\link[base]{length}}. Defaults to \code{"gray"}.}

\item{arrow.type}{Sets the type of line segments plotted. If set to
\code{"proportional"} the \code{\link[base]{length}} of the line segments
reflects the magnitude of the derivative. If set to \code{"equal"} the line
segments take equal lengths, simply reflecting the gradient of the
derivative(s). Defaults to \code{"equal"}.}

\item{arrow.head}{Sets the length of the arrow heads. Passed to
\code{\link[graphics]{arrows}}. Defaults to \code{0.05}.}

\item{frac}{Sets the fraction of the theoretical maximum length line
segments can take without overlapping, that they can actually attain. In
practice, \code{frac} can be set to greater than 1 without line segments
overlapping. Fine tuning here assists the creation of aesthetically pleasing
plots. Defaults to \code{1}.}

\item{add}{Logical. If \code{TRUE}, the flow field is added to an existing
plot. If \code{FALSE}, a new plot is created. Defaults to \code{TRUE}.}

\item{xlab}{Label for the x-axis of the resulting plot.}

\item{ylab}{Label for the y-axis of the resulting plot.}

\item{\dots}{Additional arguments to be passed to either
\code{\link[graphics]{plot}} or \code{\link[graphics]{arrows}}.}
}
\value{
Returns a \code{\link[base]{list}} with the following components (the
exact make up is dependent on the value of \code{system}):
\item{add}{As per input.}
\item{arrow.head}{As per input.}
\item{arrow.type}{As per input.}
\item{col}{As per input, but with possible editing if a
\code{\link[base]{character}} \code{\link[base]{vector}} of the wrong
\code{\link[base]{length}} was supplied.}
\item{deriv}{As per input.}
\item{dx}{A \code{\link[base]{numeric}} \code{\link[base]{matrix}}. In the
case of a two-dimensional system, the values of the derivative of the first
dependent derivative at all evaluated points.}
\item{dy}{A \code{\link[base]{numeric}} \code{\link[base]{matrix}}. In the
case of a two-dimensional system, the values of the derivative of the second
dependent variable at all evaluated points. In the case of a one-dimensional
system, the values of the derivative of the dependent variable at all
evaluated points.}
\item{frac}{As per input.}
\item{parameters}{As per
input.}
\item{points}{As per input.}
\item{system}{As per input.}
\item{x}{A \code{\link[base]{numeric}} \code{\link[base]{vector}}. In the
case of a two-dimensional system, the values of the first dependent variable
at which the derivatives were computed. In the case of a one-dimensional
system, the values of the independent variable at which the derivatives were
computed.}
\item{xlab}{As per input.}
\item{xlim}{As per input.}
\item{y}{A \code{\link[base]{numeric}} \code{\link[base]{vector}}. In the
case of a two-dimensional system, the values of the second dependent variable
at which the derivatives were computed. In the case of a one-dimensional
system, the values of the dependent variable at which the derivatives were
computed.}
\item{ylab}{As per input.}
\item{ylim}{As per input.}
}
\description{
Plots the flow or velocity field for a one- or two-dimensional autonomous ODE
system.
}
\examples{
#See archived phaseR package for examples
}
\seealso{
\code{\link[graphics]{arrows}}, \code{\link[graphics]{plot}}
}
\author{
Michael J Grayling
}
