% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_gft}
\alias{pub_gft}
\title{Google Flu Trends data}
\usage{
pub_gft(locations, epiweeks, fetch_args = fetch_args_list())
}
\arguments{
\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}} Epiweeks to fetch.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/gft.html}

Obtains estimates of inluenza activity based on volume of certain search
queries from Google.
}
\details{
Google has discontinued Flu Trends and this is now a static
endpoint. Possibile input for locations can be found in
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/regions.txt},
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/states.txt},
and
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/cities.txt}.
}
\examples{
\dontrun{
pub_gft(locations = "hhs1", epiweeks = epirange(201201, 202001))
}
}
\keyword{endpoint}
