% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_flusurv}
\alias{pub_flusurv}
\title{FluSurv hospitalization data}
\usage{
pub_flusurv(
  locations,
  epiweeks,
  ...,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{locations}{character. Character vector indicating location.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/flusurv.html}.

Obtain information on flu hospitalization rates from the Center of Disease
Control.

See also \url{https://gis.cdc.gov/GRASP/Fluview/FluHospRates.html}.
}
\details{
The list of location argument can be found in
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/flusurv_locations.txt}.
}
\examples{
\dontrun{
pub_flusurv(locations = "CA", epiweeks = epirange(201701, 201801))
}
}
\keyword{endpoint}
