% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/employment.r
\name{get_underemployment}
\alias{get_underemployment}
\title{Retreive the share of the labor force that is "underemployed"}
\usage{
get_underemployment(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or character string with any combination of \code{g} (Gender),
\code{r} (Race), \code{a} (Age), \code{e} (Education). i.e. if you want to retrieve
unemployment data by gender, race and education, you would set this parameter to "\code{gre}".}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
Underemployment is the share of the labor force that either 1) is unemployed, 2) is
working part time but wants and is available to work full time (an "involuntary" part
timer), or 3) wants and is available to work and has looked for work in the last year
but has given up actively seeking work in the last four weeks ("marginally attached"
worker).
}
\examples{
get_underemployment()

get_underemployment("r")

get_underemployment("grae")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}
