% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{OWL}
\alias{OWL}
\title{Implements the outcome weighted learning approach}
\usage{
OWL(A, X, Y, propensity, ...)
}
\arguments{
\item{A}{target variant. If not binary, the variable A must be encoded
as either (0, 1) or (0, 1, 2).}

\item{X}{rest of the genotype}

\item{Y}{phenotype (binary or continuous)}

\item{propensity}{propensity scores (a vector or a two-column matrix)}

\item{...}{additional arguments to \code{\link{stabilityGLM}}}
}
\value{
a vector containing the area under the stability selection path for
  each variable in \code{X}
}
\description{
To recover the synergistic interactions between the target \code{A} and the
rest of the genotype \code{X}, \code{OWL} formulates a weighted binary
classification problem. The outcome is the mapping of \code{A} to \{0,1\}. The
covariates are \code{X}. The propensity scores and the phenotypes are
combined in the sample weights \eqn{Y/\pi(A| X)}{Y/P(A|X)}. For binary
phenotypes, OWL is a case-only approach. The approach also accommodates
nonnegative continuous phenotypes.
}
\details{
For continuous phenotypes, if the outcome \code{Y} is
  not nonnegative, it is translated to make it nonnegative.
}
\examples{
n <- 30
p <- 10
X <- matrix((runif(n * p) < 0.5) + (runif(n * p) < 0.5), ncol = p, nrow = n)
A <- (runif(n, min = 0, max = 1) < 0.3)
propensity <- runif(n, min = 0.4, max = 0.8)
Y <- runif(n, min = 0, max = 1) < 1/ (1 + exp(-X[, c(1, 7)] \%*\% rnorm(2)))
OWL(A, X, Y, propensity, short = FALSE, n_lambda = 50, n_subsample = 1)

}
\references{
Zhao, Y., Zeng, D., Rush, A. J., & Kosorok, M. R. (2012).
  Estimating Individualized Treatment Rules Using Outcome Weighted Learning.
  Journal of the American Statistical Association, 107(499), 1106–1118.
}
