% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_in_amr_files.R
\name{read_in_amr_files}
\alias{read_in_amr_files}
\title{Convert raw AMR CSV files to data table}
\arguments{
\item{path.to.amr.files}{path to folder containing raw CSV files from ARMA
CARD analysis}

\item{coveragenumber}{Minimum percentage of a gene that must be
covered. Range from 0 to 99, default = 80}

\item{keepSNP}{TRUE or FALSE: whether to keep AMR gene conferred by one SNP
change, default = FALSE}
}
\value{
data.table of AMR genes at a specific coverage with or
without SNP associated
}
\description{
Convert raw AMR CSV files to data table
}
\examples{
\dontrun{
read_in_amr_files(path.to.amr.files = "~/Desktop/my.files/",
coveragenumber = 80, keepSNP = FALSE)
}
}
