% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/depan.R
\name{depan}
\alias{depan}
\title{Probability density function (pdf) for an uncensored epanechnikov distribution}
\usage{
depan(x = 0, mu = 0, r = 5^0.5)
}
\arguments{
\item{x}{point on x-axis.}

\item{mu}{mean of distribution.}

\item{r}{half the range of the distribution, ie the distance from the mean to the smallest/largest value supported by the distribution. \code{r=5^.5} corresponds to a standard deviation of 1.}
}
\value{
point density associated with \code{x}, \code{mu} and \code{r}.
}
\description{
This function is simply a polynomial of second degree.
}
\examples{
#Probability distribution function, epanechnikov:
curve(depan(x),col="blue",ylim=c(0,.4),xlim=c(-3.5,3.5),yaxs="i",xaxs="i",
main="Probability distribution function",ylab="Probability")

#Probability distribution function, normal:
curve(dnorm(x),col="green",add=TRUE)

#Legend
legend(x=-3.5,y=.4,legend=c("Epanechnikov pdf","Normal pdf"),lty=c(1,1),col=c("blue","green"))
}
\keyword{distribution}

