% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpcomingSplitsAPI.R
\name{get_upcoming_splits_data}
\alias{get_upcoming_splits_data}
\title{Get upcoming splits data}
\usage{
get_upcoming_splits_data(api_token, from_date = NULL, to_date = NULL)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{from_date}{Format: YYYY-MM-DD. The start date for splits data, if not provided, today will be used.}

\item{to_date}{Format: YYYY-MM-DD. The end date for splits data, if not provided, today + 7 days will be used.}
}
\value{
A list containing the upcoming splits data.
}
\description{
This function retrieves upcoming splits data from the API.
}
\examples{
api_token <- "demo"
from_date <- "2017-09-10"
to_date <- "2017-09-12"
result <- get_upcoming_splits_data(api_token, from_date, to_date)

}
