% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{collapse_root_and_member}
\alias{collapse_root_and_member}
\title{Put together a root name with a member name}
\usage{
collapse_root_and_member(root, member)
}
\arguments{
\item{root}{String containing the root name to concatenate. It may be NULL or empty.}

\item{member}{String containing the member name to concatenate. It may be NULL or empty.}
}
\value{
A string concatenating the root and the member names with the
\code{$} symbol. If any of them is empty or \code{NULL}, the other name is returned
or \code{""} if the other name is also empty or \code{NULL}.
}
\description{
This is the opposite operation of \code{extract_root_and_last_member()}:
the \code{root} and its supposed \code{member} are put together using the
\code{$} separator, as in \code{env_of_envs$env1$x}, where the root and
the member could be either \code{env_of_envs$env1} and \code{x} or
\code{env_of_envs} and \code{env1$x}.
}
\seealso{
\code{extract_root_and_last_member()}
}
