#' @title KA5 soil texture classes
#' 
#' @description
#' Soil texture classes for texture triangles as provided by
#' \emph{Bodenkundliche Kartieranleitung} (Sponagel et al., 2005)
#' 
#' @format
#' A data frame containing 71 rows and 5 columns with information on:
#' \tabular{ll}{
#' Clay: \tab the clay fraction in percent\cr
#' Silt: \tab the silt fraction in percent\cr
#' Sand: \tab the sand fraction in percent\cr
#' Group: \tab the respective soil texture group\cr
#' Class: \tab the main soil texture class\cr
#' }
#' 
#' @references
#' Sponagel, H., Grottenthaler, W., Hartmann, K.J., Hartwich, R., Janetzko,
#' P., Joisten, H., Kühn, D., Sabel, K.J., Traidl, R., 2005. Bodenkundliche
#' Kartieranleitung: mit 103 Tabellen und 31 Listen, 5.,  und  erw. Aufl. ed.
#' Schweizerbart, Stuttgart.
#' 
#' @docType data
#' @keywords data
#' @name ka5
NULL
