% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemblQueryLDpairEndpoint.R
\name{ensemblQueryLDwithSNPpairDataframe}
\alias{ensemblQueryLDwithSNPpairDataframe}
\title{`ensemblQueryLDwithSNPpairDataframe` applies `ensemblQueryLDwithSNPpair` to a data.frame of rsID pairs}
\usage{
ensemblQueryLDwithSNPpairDataframe(
  in.table,
  pop = "1000GENOMES:phase_3:EUR",
  cores = 1
)
}
\arguments{
\item{in.table}{data.frame containing SNP pairs. Columns must include `rsid1` for the first member of the pair and `rsid2` for the second member of the pair.}

\item{pop}{String. Population for which to compute LD. Use `ensemblQueryGetPops()` to retrieve a list of all populations with LD data. Default is 1000GENOMES:phase_3:EUR.}

\item{cores}{Integer. A value between 1 and 10 is accepted, as this prevents the server returning overload-related errors.}
}
\value{
A dataframe.
}
\description{
`ensemblQueryLDwithSNPpairDataframe` applies `ensemblQueryLDwithSNPpair` to a data.frame of rsID pairs
}
\examples{
ensemblQueryLDwithSNPpairDataframe(
 in.table=data.frame(rsid1=rep("rs6792369", 10),
                     rsid2=rep("rs1042779", 10)),
                     pop="1000GENOMES:phase_3:EUR"
)

}
