% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.enpls.R
\name{plot.cv.enpls}
\alias{plot.cv.enpls}
\title{Plot cv.enpls object}
\usage{
\method{plot}{cv.enpls}(x, xlim = NULL, ylim = NULL, alpha = 0.8,
  main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{cv.enpls}.}

\item{xlim}{x Vector of length 2 - x axis limits of the plot.}

\item{ylim}{y Vector of length 2 - y axis limits of the plot.}

\item{alpha}{An alpha transparency value for points, a real number in (0, 1].}

\item{main}{Plot title, not used currently.}

\item{...}{Additional graphical parameters, not used currently.}
}
\description{
Plot cv.enpls object
}
\examples{
data("alkanes")
x <- alkanes$x
y <- alkanes$y

set.seed(42)
cvfit <- cv.enpls(x, y, reptimes = 10)
plot(cvfit)
}
\seealso{
See \code{\link{cv.enpls}} for cross-validation of
ensemble partial least squares regression models.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
