% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.enspls.R
\name{cv.enspls}
\alias{cv.enspls}
\title{Cross Validation for Ensemble Sparse Partial Least Squares Regression}
\usage{
cv.enspls(x, y, nfolds = 5L, verbose = TRUE, ...)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{nfolds}{number of folds - default is \code{5}.}

\item{verbose}{shall we print the cross validation process}

\item{...}{other arguments that can be passed to \code{\link{enspls.fit}}}
}
\value{
A list containing:
\itemize{
\item \code{ypred} - a matrix containing two columns: real y and predicted y
\item \code{residual} - cross validation result (y.pred - y.real)
\item \code{RMSE} - RMSE
\item \code{MAE} - MAE
\item \code{Rsquare} - Rsquare
}
}
\description{
K-fold cross validation for ensemble sparse partial least squares regression.
}
\note{
To maximize the probablity that each observation can
be selected in the test set (thus the prediction uncertainty
can be measured), please try setting a large \code{MCtimes}.
}
\examples{
# This example takes one minute to run
\dontrun{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
cvfit = cv.enspls(x, y, MCtimes = 10)
print(cvfit)
plot(cvfit)}
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.fit}} for ensemble sparse
partial least squares regression.
}

