% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_glm.R
\name{fit_selected}
\alias{fit_selected}
\alias{fit_glms}
\title{Fitting selected GLMs models}
\usage{
fit_selected(glm_calibration)

fit_glms(formulas, data, weights = NULL, id = NULL)
}
\arguments{
\item{glm_calibration}{a list resulting from \code{\link{calibration_glm}}.
Models fitted are those in the slot "selected".}

\item{formulas}{(character) a vector containing the formula(s) for GLM(s).}

\item{data}{data.frame with the dependent and independent variables.}

\item{weights}{(numeric) a vector with the weights for observations.
Default = NULL.}

\item{id}{(character) id code for models fitted. Default = NULL.}
}
\value{
A list of fitted GLMs.

For \code{fit_selected}, an enmpa \verb{fitted models} object.
}
\description{
Functions to facilitate fitting multiple GLMs.
}
\examples{
# GLM calibration results
data(cal_res, package = "enmpa")

# Fitting selected models
sel_fit <- fit_selected(cal_res)

sel_fit

# Custom formulas
forms <- c("Sp ~ bio_1 + I(bio_1^2) + I(bio_12^2)",
           "Sp ~ bio_12 + I(bio_1^2) + I(bio_12^2)")

# Fitting models
fits <- fit_glms(forms, data = cal_res$data)

fits$ModelID_1
}
