% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utf8.R
\name{utf8}
\alias{utf8}
\alias{utf8}
\alias{is_utf8}
\alias{as_utf8}
\alias{as_utf8.default}
\alias{as_utf8.NULL}
\alias{as_utf8.character}
\alias{as_utf8.utf8}
\alias{as.character.utf8}
\alias{as.data.frame.utf8}
\alias{format.utf8}
\alias{print.utf8}
\title{A simple class for storing UTF-8 strings}
\usage{
utf8(x = character())

is_utf8(x)

as_utf8(x, ...)

\method{as_utf8}{default}(x, ...)

\method{as_utf8}{NULL}(x, ...)

\method{as_utf8}{character}(x, ...)

\method{as_utf8}{utf8}(x, ...)

\method{as.character}{utf8}(x, ...)

\method{as.data.frame}{utf8}(x, row.names = NULL, optional = FALSE, ...,
  nm = paste(deparse(substitute(x), width.cutoff = 500L), collapse = " "))

\method{format}{utf8}(x, ...)

\method{print}{utf8}(x, ...)
}
\arguments{
\item{x}{A vector}

\item{...}{Arguments passed on to further methods.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link{data.frame}(*, check.names = !optional)}.}

\item{nm}{Name of column in new data frame}
}
\description{
The values are stored as a \code{\link[=character]{character()}} vector.
On construction, the \code{\link[=enc2utf8]{enc2utf8()}} function is called on the
input.  Subsetting and concatenation operations on an object of this class
return an object of this class again.
Calls to \code{\link[=Encoding<-]{Encoding<-()}} are not intercepted.
}
\examples{
utf8(letters)
utf8("ä")
utf8(iconv("ä", to = "latin1"))
}
