% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_g2pForPronunciation}
\alias{runBASwebservice_g2pForPronunciation}
\title{Creates canonical pronunciation attributes for a tier of tokenized orthographical words.}
\usage{
runBASwebservice_g2pForPronunciation(handle, orthoAttributeDefinitionName,
  language, canoAttributeDefinitionName = "KAN", params = list(embed =
  "maus"), patience = 0, resume = FALSE, verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{orthoAttributeDefinitionName}{name of a attribute (not level!) containing orthographic words.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{canoAttributeDefinitionName}{attribute name for canonical pronunciations of words}

\item{params}{named list of parameters to be passed on to the webservice. It is your own responsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{patience}{If a web service call fails, it is repeated a further n times, with n being the value of patience.
Must be set to a value between 0 and 3.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
This function calls the G2P webservice to add canonical pronunciation attributes in SAMPA (default)
or IPA to a tier of tokenized orthographical words. It is usually called after tokenization
with \link{runBASwebservice_g2pForTokenization}. Its output can be used as input to
\link{runBASwebservice_maus} or \link{runBASwebservice_chunker}.
\strong{This function requires an internet connection.}
}
\details{
By default, G2P is called in MAUS embed mode. This is important if you intend to use MAUS
afterwards. To disable MAUS embed mode, call this function with params=list(embed="no").
To derive IPA symbols, add outsym="ipa" to the parameter list.
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylCanonical}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
\concept{BAS webservice functions}
