% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by.trackdata.R
\name{by.trackdata}
\alias{by.trackdata}
\alias{by}
\title{A method of the generic function by for objects of class \'trackdata\'}
\usage{
\method{by}{trackdata}(data, INDICES = NULL, FUN, ..., simplify = FALSE)
}
\arguments{
\item{data}{a track data object}

\item{INDICES}{a list of segment indices, like a label vector}

\item{FUN}{a function that is applied to each segment}

\item{\dots}{arguments of the function fun}

\item{simplify}{simplify = TRUE , output is a matrix; simplify = FALSE a
list is returned}
}
\value{
list or vector
}
\description{
A given function 'FUN' is applied to the data corresponding to each segment
of data.
}
\details{
It is the same as trapply but with the extension to subsume calculation to
groups of segments. Note, if you do not want to apply the function fun to a
special group of segments, use \link{trapply} instead.
}
\examples{

  data(demo.vowels)
  data(demo.vowels.fm)


   #mean F1 subsumed for each vowel
   ################################
   lab = label(demo.vowels)
   by(demo.vowels.fm[,1], lab ,sapply,mean,simplify=FALSE)


   #mean F1 subsumed for segment onsets mids and offsets
   ##############################################
   data = demo.vowels.fm
   llabs = NULL
   for (ind in 1:dim(data$ftime)[1]) {
     seglabs = rep("mid",data$index[ind,2]-data$index[ind,1]+1)
     seglabs[1] = "on"
     seglabs[length(seglabs)] = "off"
     llabs = as.vector(c(llabs , seglabs))
   }

   by(demo.vowels.fm[,1], llabs , sapply, mean , simplify=FALSE)

   #mean F1 subsumed for segment onsets mids and offsets subsumed for each vowel
   #####################################################################
   by(demo.vowels.fm[,1], list(lab = lab, llabs = llabs) , sapply, mean , simplify=FALSE)



}
\seealso{
\code{\link{trapply}}, \code{\link{by}}, \code{\link{trackdata}}
\code{\link{dapply}} \code{\link{smooth}} \code{\link{apply}}
}
\author{
Jonathan Harrington
}
\keyword{methods}
