% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFdiv.R
\name{MFdiv}
\alias{MFdiv}
\title{Calculate Multifunctionality Divergence (MFdiv)}
\usage{
MFdiv(data, weights = NULL, cor = FALSE)
}
\arguments{
\item{data}{A data frame or matrix where rows represent observations and columns represent functions.}

\item{weights}{A numeric vector of weights for each function (column). If NULL, equal weights are assigned.}

\item{cor}{Logical. If TRUE, calculates MFdiv with redundancy correction based on correlation between functions.
If FALSE, calculates uncorrected MFdiv.}
}
\value{
A data frame with MFdiv values for each observation (row) in the input data.
}
\description{
Multifunctionality divergence (MFdiv) was calculated to quantify the degree of difference between different functions of an ecosystem.
MFdiv was calculated by the mean pairwise distance method.
}
\details{
To measure MFdiv quantitatively, we employ the mean pairwise distance method (Webb et al., 2002).

For uncorrected MFdiv, the formula is:
\deqn{MFdiv = \frac{\sum_{i=1}^{n}\sum_{j=i+1}^{n}{w_i w_j D_{ij}}}{\sum_{i=1}^{n}\sum_{j=i+1}^{n}{w_i w_j}}}{MFdiv = (sum of weighted distances)/(sum of weights)}
where \eqn{D_{ij} = |f_i - f_j|}

When redundancy correction is applied (`cor = TRUE`), the function accounts for correlations
between ecosystem functions. The correction process involves:

1. Calculating a distance matrix based on correlations: \eqn{d_{ij} = \sqrt{1 - |r_{ij}|}}

2. Applying threshold-based correction: \eqn{d_{ij}(\tau) = \min(d_{ij}, \tau)}

3. Computing effective function values:
   \eqn{F_i(\tau) = \sum_{j=1}^{L}(1 - \frac{d_{ij}(\tau)}{\tau})f_j}

4. Calculating the corrected MFdiv using these effective function values:
   \deqn{D_{ij}(\tau) = |F_i - F_j|}
   \deqn{MFdiv = \frac{\sum_{i=1}^{n}\sum_{j=i+1}^{n}{w_i w_j D_{ij}(\tau)}}{\sum_{i=1}^{n}\sum_{j=i+1}^{n}{w_i w_j}}}{MFdiv = (sum of weighted distances)/(sum of weights)}

5. The final result is the area under the curve (AUC) of MFdiv values across different tau thresholds.
}
\examples{
data(forestfunctions)
head(forestfunctions)
MFdiv(forestfunctions[,6:31], cor = FALSE)

}
