% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.MHmcmc_p.R
\name{HatchingSuccess.MHmcmc_p}
\alias{HatchingSuccess.MHmcmc_p}
\title{Generates set of parameters to be used with HatchingSuccess.MHmcmc()}
\usage{
HatchingSuccess.MHmcmc_p(
  result = NULL,
  parameters = NULL,
  fixed.parameters = NULL,
  accept = FALSE
)
}
\arguments{
\item{result}{An object obtained after a HatchingSuccess.fit() fit}

\item{parameters}{A set of parameters. Replace the one from result}

\item{fixed.parameters}{A set of fixed parameters. Replace the one from result}

\item{accept}{If TRUE, the script does not wait user information}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be used with HatchingSuccess.MHmcmc().\cr
}
\details{
HatchingSuccess.MHmcmc_p generates set of parameters to be used with HatchingSuccess.MHmcmc()
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=0.8)
         
g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)
pMCMC <- HatchingSuccess.MHmcmc_p(g, accept=TRUE)
mcmc <- HatchingSuccesss.MHmcmc(result=g, parameters = pMCMC, 
                  adaptive=TRUE, n.iter=100000, trace=1000)
}
}
\seealso{
Other Hatching success: 
\code{\link{HatchingSuccess.MHmcmc}()},
\code{\link{HatchingSuccess.fit}()},
\code{\link{HatchingSuccess.lnL}()},
\code{\link{HatchingSuccess.model}()},
\code{\link{logLik.HatchingSuccess}()},
\code{\link{nobs.HatchingSuccess}()},
\code{\link{plot.HatchingSuccess}()},
\code{\link{predict.HatchingSuccess}()}
}
\author{
Marc Girondot
}
\concept{Hatching success}
