% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STRN.R
\name{STRN}
\alias{STRN}
\title{Estimate the parameters that best describe the sexualisation thermal reaction norm within the TSP}
\usage{
STRN(Initial_STRN = NULL, fixed.parameters = NULL,
  EmbryoGrowthTRN = stop("Embryo Growth Thermal Reaction Norm must be provided"),
  TSP.borders = NULL, embryo.stages = "Generic.ProportionDevelopment",
  tsd = NULL, equation = "logistic", Sexed = NULL, Males = NULL,
  Females = NULL,
  Temperatures = "TSP.MassWeighted.STRNWeighted.temperature.mean",
  SE = TRUE, parallel = TRUE, itnmax = 1000,
  method = c("Nelder-Mead", "BFGS"), control = list(trace = 1, REPORT =
  10), zero = 1e-09)
}
\arguments{
\item{Initial_STRN}{Values for initial model of Sexualisation Thermal Reaction Norm}

\item{fixed.parameters}{Value for Sexualisation Thermal Reaction Norm model that will not be changed}

\item{EmbryoGrowthTRN}{The Embryo Growth Thermal Reaction Norm obtained with searchR()}

\item{TSP.borders}{The limits of TSP in stages. See embryo.stages parameter.}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP borders. See note.}

\item{tsd}{The model used to predict sex ratio, obtained from tsd()}

\item{equation}{If tsd parameter is not provided, equation and parameters for tsd model must be provided.}

\item{Sexed}{The number of sexed embryos with names identifying timeseries}

\item{Males}{The number of males embryos with names identifying timeseries}

\item{Females}{The number of females embryos with names identifying timeseries}

\item{Temperatures}{The temperature from out of info.nests to be used}

\item{SE}{Should standard error of parameters and Hessian matrix be estimated ? TRUE or FALSE}

\item{parallel}{Should parallel computing for info.nests() be used}

\item{itnmax}{Maximum number of iterations for each method}

\item{method}{Methods to be used with optimx}

\item{control}{List for control parameters for optimx}

\item{zero}{The value to replace a null sex ratio}
}
\value{
The list with object return by optim()
}
\description{
Estimate the parameters that best describe the sexualisation thermal reaction norm within the TSP.\cr
The Temperatures parameter is a character string which can be:\cr
\itemize{
  \item \code{TimeWeighted.temperature.mean}
  \item \code{TSP.TimeWeighted.temperature.mean}
  \item \code{TSP.MassWeighted.temperature.mean}
  \item \code{TSP.STRNWeighted.temperature.mean}
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.mean}
  \item \code{MiddleThird.TimeWeighted.temperature.mean}
  }
If information for sex is not known for some timeseries, set NA for Sexed.\cr
Sexed, Males and Females must be vectors with names. The names must be the same as 
the names of timeseries of temperatures in EmbryoGrowthTRN.\cr
Only two of these 3 parameters are required: Males, Females and Sexed\cr
Note: four species have predefined embryo stages. embryo.stages parameter can take the values:\cr
\itemize{
  \item \code{Caretta caretta.SCL}
  \item \code{Chelonia mydas.SCL}
  \item \code{Emys orbicularis.SCL}
  \item \code{Emys orbicularis.mass}
  \item \code{Podocnemis expansa.SCL}
  \item \code{Generic.ProportionDevelopment}
}
}
\details{
STRN estimates the parameters that best describe the sexualisation thermal reaction norm within the TSP
}
\examples{
\dontrun{
library(embryogrowth)
MedIncubation_Cc <- subset(DatabaseTSD, Species=="Caretta caretta" & 
RMU=="Mediterranean" & Sexed!=0)
Med_Cc <- with(MedIncubation_Cc, tsd(males=Males, females=Females, 
 temperatures=Incubation.temperature, par=c(P=29.5, S=-0.01)))
plot(Med_Cc, xlim=c(25, 35))
males <- c(7, 0, 0, 0, 0, 5, 6, 3, 5, 3, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0)
names(males) <- rev(rev(names(resultNest_4p_SSM4p$data))[-(1:2)])
sexed <- rep(10, length(males))
names(sexed) <- rev(rev(names(resultNest_4p_SSM4p$data))[-(1:2)])
Initial_STRN <- resultNest_4p_SSM4p$par[c("DHA_STRN", "DHH_STRN", "T12H_STRN")]
Initial_STRN <- structure(c(582.567096666926, 2194.0806711639, 3475.28414940385), 
                          .Names = c("DHA_STRN", "DHH_STRN", "T12H_STRN"))
fp <- c(Rho25_STRN=100)
fitSTRN <- STRN(Initial_STRN=Initial_STRN, 
                EmbryoGrowthTRN=resultNest_4p_SSM4p, tsd=Med_Cc, 
                embryo.stages="Caretta caretta.SCL", 
                Sexed=sexed, Males=males, 
                fixed.parameters=fp, 
                SE=TRUE, 
                Temperatures="TSP.MassWeighted.STRNWeighted.temperature.mean")
plotR(fitSTRN, curves ="ML quantiles", ylim=c(0,2))
CTE <- info.nests(NestsResult=resultNest_4p_SSM4p, 
                  SexualisationTRN=fitSTRN,
                  SexualisationTRN.CI="Hessian",
                  embryo.stages="Caretta caretta.SCL", 
                  CI="Hessian", 
                  replicate.CI=100, 
                  progress=TRUE, 
                  warnings=TRUE, 
                  out="summary")$summary
# CTE with growth-weighted temperature average
plot(Med_Cc, xlim=c(25, 35))
points(x=CTE$TSP.MassWeighted.temperature.mean, y=males/sexed, 
         col="red", pch=19)
legend("topright", legend=c("CTE with growth-weighted TRN"), 
         pch=19, col=c("red"))
# CTE with sexualisation TRN and growth-weighted temperature average
plot(Med_Cc, xlim=c(25, 35))
points(x=CTE$TSP.MassWeighted.STRNWeighted.temperature.mean, y=males/sexed, 
         col="red", pch=19)
legend("topright", legend=c("CTE with growth-weighted TRN and Sex. TRN"), 
       pch=19, col=c("red"))
xx <- seq(from=20, to=35, by=0.1)
plot(x=xx, 
         y=log10(getFromNamespace(".SSM", ns="embryogrowth")(xx, 
                            c(fitSTRN$par, fitSTRN$fixed.parameters))[[1]]), 
         type="l", bty="n", xlim=c(20, 35), ylim=c(-20, 20), 
         xlab="Temperature", ylab="Sexualisation thermal reaction norm (log10)")
         
# Using only the sexualisation thermal reaction norm within TSP to calculate CTE

Initial_STRN <- resultNest_4p_SSM4p$par[c("DHA_STRN", "DHH_STRN", "T12H_STRN")]
Initial_STRN <- structure(c(3678.94960547096, -301.436485427701, 912.595953854977), 
                          .Names = c("DHA_STRN", "DHH_STRN", "T12H_STRN"))
fp <- c(Rho25_STRN=100)
fitSTRN_2 <- STRN(Initial_STRN=Initial_STRN, 
                EmbryoGrowthTRN=resultNest_4p_SSM4p, tsd=Med_Cc, 
                embryo.stages="Caretta caretta.SCL", 
                Sexed=sexed, Males=males, 
                fixed.parameters=fp,  
                Temperatures="TSP.STRNWeighted.temperature.mean")
CTE <- info.nests(NestsResult=resultNest_4p_SSM4p, 
                  SexualisationTRN=fitSTRN_2,
                  SexualisationTRN.CI="Hessian",
                  embryo.stages="Caretta caretta.SCL", 
                  CI="Hessian", 
                  replicate.CI=100, 
                  progress=TRUE, 
                  warnings=TRUE, 
                  out="summary")$summary
# CTE with sexualisation TRN
plot(Med_Cc, xlim=c(25, 35))
points(x=CTE$TSP.STRNWeighted.temperature.mean, y=males/sexed, 
         col="red", pch=19)
legend("topright", legend=c("CTE with Sexualisation TRN"), 
       pch=19, col=c("red"))
xx <- seq(from=20, to=35, by=0.1)
plot(x=xx, 
         y=getFromNamespace(".SSM", ns="embryogrowth")(xx, 
                            c(fitSTRN$par, fitSTRN$fixed.parameters))[[1]], 
         type="l", bty="n", xlim=c(20, 35), ylim=c(0, 1E-18), 
         xlab="Temperature", ylab="Sexualisation thermal reaction norm")
}
}
\author{
Marc Girondot
}
