#' logLik.STRN Return Log Likelihood of a fit
#' @title Return Log Likelihood of a fit generated by STRN
#' @author Marc Girondot
#' @return The Log Likelihood value of the fitted model and data
#' @param object A result file generated by STRN
#' @param ... Not used
#' @description Return Log Likelihood of a fit generated by STRN
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' data(resultNest_4p_SSM4p)
#' logLik(resultNest_4p_SSM4p)
#' AIC(resultNest_4p_SSM4p)
#' }
#' @method logLik STRN
#' @export


logLik.STRN <- function(object, ...) {
  l <- -object$value
  attributes(l) <- list(nall=length(object$data$Sexed), nobs=length(object$data$Sexed), df=length(object$par) , class="logLik")
  return(l)
}
