% Generated by roxygen2 (4.0.2): do not edit by hand
\name{GenerateConstInc}
\alias{GenerateConstInc}
\title{Generate a data.frame with constant incubation temperature and incubation duration}
\usage{

  GenerateConstInc(durations = stop("At least one incubation length must be provided"),
  temperatures = stop("At least one incubation temperature must be provided"),
  names = NULL)
}
\arguments{
\item{durations}{A vector with incubation durations}

\item{temperatures}{A vector with incubation temperatures}

\item{names}{A vector of column names}
}
\value{
A date.frame that can be used with FormatNests()
}
\description{
Generate a data.frame from constant incubation temperature and incubation duration
}
\details{
GenerateConstInc generates a data.frame with constant incubation temperature and incubation duration
}
\examples{
\dontrun{
temp_cst <- GenerateConstInc(durations=c(150000, 100100, 100000),
	temperatures=c(28, 30.5, 30.6),
	names=c("T28", "T30.5", "T30.6"))
}
}
\author{
Marc Girondot
}

