% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{get_synergy_subset_stats}
\alias{get_synergy_subset_stats}
\title{Find the number of predictive models for every synergy subset}
\usage{
get_synergy_subset_stats(model.predictions, synergies)
}
\arguments{
\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models).}

\item{synergies}{a character vector with elements the synergistic drug
combinations. Note that these synergies should be a subset of the column
names of the \code{model.predictions} data.frame.}
}
\value{
an integer vector with elements the number of models the predicted
each synergy subset. The \emph{names} attribute has the names of each
synergistic drug combination subset, which are the drug combinations comma
separated (e.g. 'A-B,C-D').
}
\description{
Use this function to find for each possible subset of drug combinations out
of a given list of synergies, the number of models that predicted it given
the models' predictions. So, if for example the set of synergies is this one:
\{'A-B','C-D','E-F'\}, we want to know how many models predicted none of them,
just the single subsets (e.g. the \{'A-B'\}),
the two-element subsets (e.g. the \{'A-B','C-D'\}) and all 3 of them.
}
\section{Details}{

Note that if the \code{synergies} vector has more than 10-15 elements, then
this function might take long time to execute even with an optimal
implementation of \code{\link{count_models_that_predict_synergies}}.
}

