% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}
\alias{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}
\title{Get average activity difference matrix based on specific synergy prediction}
\usage{

  get_avg_activity_diff_mat_based_on_specific_synergy_prediction(model.predictions,
  models.stable.state, predicted.synergies)
}
\arguments{
\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{models.stable.state}{a matrix (nxm) with n models and m nodes. The row
names of the matrix specify the models' names
whereas the column names specify the name of the network nodes
(gene, proteins, etc.). Possible values for each \emph{model-node element}
are either \emph{0} (inactive node) or \emph{1} (active node).}

\item{predicted.synergies}{a character vector of the synergies (drug
combination names) that were predicted by \strong{at least one} of the models
in the dataset. It must be a subset of the column names (the drug combinations)
of the \code{model.predictions} object.}
}
\value{
a matrix whose rows are \strong{vectors of
average node activity state differences} between two groups of models where
the classification for each individual row was based on the prediction or not
of a specific synergistic drug combination.
The row names are the predicted synergies, one per row, while the columns
represent the network's node names. Values are in the [-1,1] interval.
}
\description{
This function uses the \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}}
function on a vector of drug combinations that were observed as synergistic
(e.g. by experiments) but also found as such by at least one of the models
(these drug combinations are the \emph{predicted synergies}).
}
\seealso{
Other average data difference functions: \code{\link{get_avg_activity_diff_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}},
  \code{\link{get_avg_activity_diff_based_on_tp_predictions}},
  \code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_activity_diff_mat_based_on_tp_predictions}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}},
  \code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}}
}
\concept{average data difference functions}
