% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{calculate_mcc}
\alias{calculate_mcc}
\title{Calculate the Matthews correlation coefficient vector}
\usage{
calculate_mcc(tp, tn, fp, fn, p, n)
}
\arguments{
\item{tp}{numeric vector of TPs}

\item{tn}{numeric vector of TNs}

\item{fp}{numeric vector of FPs}

\item{fn}{numeric vector of FNs}

\item{p}{numeric vector of positives (p = tp + fn)}

\item{n}{numeric vector of negatives (n = tn + fp)}
}
\value{
a numeric vector of MCC values, each value being in the [-1,1]
interval or \emph{NaN}.
}
\description{
Use this function to calculate the MCC values given vectors of \emph{TP} (true
positives), \emph{FP} (false positives), \emph{TN} (true negatives), \emph{FN}
(false negatives), \emph{P} (positives) and \emph{N} (negatives). Note that
the input vectors have to be of the same size and have one-to-one value
correspondence for the output MCC vector values to make sense.
}
\seealso{
Other confusion matrix calculation functions: \code{\link{calculate_models_mcc}},
  \code{\link{calculate_models_synergies_fn}},
  \code{\link{calculate_models_synergies_fp}},
  \code{\link{calculate_models_synergies_tn}},
  \code{\link{calculate_models_synergies_tp}}
}
\concept{confusion matrix calculation functions}
