% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools-def.R
\name{tool}
\alias{tool}
\title{Define a tool}
\usage{
tool(.fun, .description, ..., .name = NULL)
}
\arguments{
\item{.fun}{The function to be invoked when the tool is called.}

\item{.description}{A detailed description of what the function does.
Generally, the more information that you can provide here, the better.}

\item{...}{Name-type pairs that define the arguments accepted by the
function. Each element should be created by a \code{\link[=type_boolean]{type_*()}}
function.}

\item{.name}{The name of the function.}
}
\value{
An S7 \code{ToolDef} object.
}
\description{
Define an R function for use by a chatbot. The function will always be
run in the current R instance.

Learn more in \code{vignette("tool-calling")}.
}
\examples{
\dontshow{if (has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# First define the metadata that the model uses to figure out when to
# call the tool
tool_rnorm <- tool(
  rnorm,
  "Drawn numbers from a random normal distribution",
  n = type_integer("The number of observations. Must be a positive integer."),
  mean = type_number("The mean value of the distribution."),
  sd = type_number("The standard deviation of the distribution. Must be a non-negative number.")
)
chat <- chat_openai()
# Then register it
chat$register_tool(tool_rnorm)

# Then ask a question that needs it.
chat$chat("
  Give me five numbers from a random normal distribution.
")

# Look at the chat history to see how tool calling works:
# Assistant sends a tool request which is evaluated locally and
# results are send back in a tool result.
\dontshow{\}) # examplesIf}
}
