% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{+.elastic_api}
\alias{+.elastic_api}
\title{Define Elasticsearch aggregation on a secific subset of documents.}
\usage{
\method{+}{elastic_api}(x, y)
}
\arguments{
\item{x}{\code{elastic_query} object.}

\item{y}{\code{elastic_aggs} or \code{elastic_sort} object.}
}
\value{
\code{elastic_aggs} object that contains the query information required for the
aggregation.
}
\description{
Sometimes it is necessary to perform an aggregation on the results of a query (i.e. on a subset
of all the available documents). This is achieved by adding an \code{aggs} object to a
\code{query} object.
}
\examples{
all_docs <- query('{"match_all": {}}')
avg_sepal_width_per_cat <- aggs('{"avg_sepal_width_per_cat": {
      "terms": {"field": "species"},
      "aggs": {"avg_sepal_width": {"avg": {"field": "sepal_width"}}}}
}')
all_docs + avg_sepal_width_per_cat

sort_by_sepal_width <- sort_on('[{"sepal_width": {"order": "asc"}}]')
all_docs + sort_by_sepal_width
}

