% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_caps.R
\name{field_caps}
\alias{field_caps}
\title{Field capabilities}
\usage{
field_caps(conn, fields, index = NULL, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{fields}{A list of fields to compute stats for. required}

\item{index}{Index name, one or more}

\item{...}{Curl args passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\description{
The field capabilities API allows to retrieve the capabilities of fields
among multiple indices.
}
\examples{
\dontrun{
x <- connect()
x$ping()

if (x$es_ver() >= 540) {
  field_caps(x, fields = "speaker", index = "shakespeare")
}

}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/search-field-caps.html}
}
\seealso{
\code{\link[=field_stats]{field_stats()}}
}
