% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tokenizer_set.R
\name{tokenizer_set}
\alias{tokenizer_set}
\title{Tokenizer operations}
\usage{
tokenizer_set(index, body, ...)
}
\arguments{
\item{index}{(character) A character vector of index names}

\item{body}{Query, either a list or json.}

\item{...}{Curl options passed on to \code{\link[httr]{PUT}}}
}
\description{
Tokenizer operations
}
\examples{
\dontrun{
# set tokenizer
## NGram tokenizer
body <- '{
        "settings" : {
             "analysis" : {
                 "analyzer" : {
                     "my_ngram_analyzer" : {
                         "tokenizer" : "my_ngram_tokenizer"
                     }
                 },
                 "tokenizer" : {
                     "my_ngram_tokenizer" : {
                         "type" : "nGram",
                         "min_gram" : "2",
                         "max_gram" : "3",
                         "token_chars": [ "letter", "digit" ]
                     }
                 }
             }
      }
}'
tokenizer_set(index = "test1", body=body)
index_analyze(text = "hello world", index = "test1", analyzer='my_ngram_analyzer')
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}

